VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmIndexFeatureLayer 
   Caption         =   "Create an Index for the Selected Feature Layer"
   ClientHeight    =   7245
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6435
   OleObjectBlob   =   "frmIndexFeatureLayer.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmIndexFeatureLayer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdCreateIndex_Click()

  'Get the active views
  Dim pMxDoc As IMxDocument
  Dim pMap As IMap
  Set pMxDoc = ThisDocument
  Set pMap = pMxDoc.FocusMap
  
  'Create Index grid and add to layout
  Dim pGraphicsContainer As IGraphicsContainer
  Dim pMapFrame As IMapFrame
  Dim pLayoutView As IActiveView
  Dim pIndexGrid As IIndexGrid
  Set pGraphicsContainer = pMxDoc.PageLayout
  Set pMapFrame = pGraphicsContainer.FindFrame(pMap)
  Set pLayoutView = pMxDoc.PageLayout
  Set pIndexGrid = CreateAndAddIndexGrid(pMapFrame, pLayoutView)
  
  'Get Selected layer
  Dim pFeatureLayer As IFeatureLayer
  If Not TypeOf pMxDoc.SelectedLayer Is IFeatureLayer Then
    MsgBox "Selected layer is not a feature layer.", vbExclamation + vbOKOnly
    Exit Sub
  End If
  Set pFeatureLayer = pMxDoc.SelectedLayer
  
  'Get the Index for this layer
  Dim rsIndex As ADODB.Recordset
  Set rsIndex = GetIndexForFeatureLayer(pFeatureLayer, pIndexGrid)
  
  'Populate listbox from recordset
  lstIndex.Clear
  rsIndex.Sort = "DisplayField, Index"
  rsIndex.MoveFirst
  Do While Not rsIndex.EOF
    lstIndex.AddItem rsIndex("DisplayField") & vbTab & rsIndex("Index"), lstIndex.ListCount
    rsIndex.MoveNext
  Loop
  rsIndex.Close
End Sub

Private Function CreateAndAddIndexGrid(pMapFrame As IMapFrame, pActiveView As IActiveView) As IIndexGrid
  'Create map grid
  Dim pMapGridFactory As IMapGridFactory
  Dim pIndexGrid As IIndexGrid
  Set pMapGridFactory = New IndexGridFactory
  Set pIndexGrid = pMapGridFactory.Create(pMapFrame)
  
  'Modify grid label font size and thickness
  Dim pIndexGridTabStyle As IIndexGridTabStyle
  Set pIndexGridTabStyle = pIndexGrid.LabelFormat
  pIndexGridTabStyle.Thickness = 10

  'Add map grid to Layout and refresh
  Dim pMapGrids As IMapGrids
  Set pMapGrids = pMapFrame
  pMapGrids.AddMapGrid pIndexGrid
  pActiveView.PartialRefresh esriViewBackground, Nothing, Nothing
  
  Set CreateAndAddIndexGrid = pIndexGrid
End Function

Private Function GetIndexForFeatureLayer(pFeatureLayer As IFeatureLayer, _
                              pIndexGrid As IIndexGrid) As ADODB.Recordset
  'Get the active views and the map frame
  Dim pMxDoc As IMxDocument
  Dim pMap As IMap
  Dim pLayoutView As IActiveView
  Dim pMapView As IActiveView
  Dim pGraphicsContainer As IGraphicsContainer
  Dim pMapFrame As IMapFrame
  Set pMxDoc = ThisDocument
  Set pMap = pMxDoc.FocusMap
  Set pLayoutView = pMxDoc.PageLayout
  Set pMapView = pMap
  Set pGraphicsContainer = pMxDoc.PageLayout
  Set pMapFrame = pGraphicsContainer.FindFrame(pMap)
  
  'Get the display transformations
  Dim pPageTransformation As IDisplayTransformation
  Dim pMapTransformation As IDisplayTransformation
  Set pPageTransformation = pLayoutView.ScreenDisplay.DisplayTransformation
  Set pMapTransformation = pMapView.ScreenDisplay.DisplayTransformation
    
  'Get the display field of the layer
  Dim pClass As IClass
  Dim lField As Long, sField As String
  Set pClass = pFeatureLayer.FeatureClass
  sField = pFeatureLayer.displayField
  lField = pClass.FindField(sField)
  
  'Create a recordset to hold the index
  Dim rsIndex As New ADODB.Recordset
  rsIndex.Fields.Append "Index", ADODB.adChar, 40
  rsIndex.Fields.Append "DisplayField", ADODB.adChar, 30
  rsIndex.Open
  
  'Loop through the cells of the grid
  Dim nRow As Integer, nCol As Integer
  Dim sCell As String
  Dim pGeometry As IGeometry, pEnv As IEnvelope, Rect As tagRECT
  Dim pFeatureCursor As IFeatureCursor, pFeature As IFeature
  Set pEnv = New Envelope
  For nCol = 0 To (pIndexGrid.columnCount - 1)
    For nRow = 0 To (pIndexGrid.rowCount - 1)
      'Cell name, e.g., "A-1"
      sCell = pIndexGrid.XLabel(nCol) & "-" & pIndexGrid.YLabel(nRow)
      
      'Get cell extent envelope
      pIndexGrid.QueryCellExtent nRow, nCol, pMapFrame, pEnv
      
      'Transform envelope from page to map coordinates
      '  Transform from Page units to Device units
      pPageTransformation.TransformRect pEnv, Rect, esriTransformToDevice + esriTransformPosition
      '  Transform from Device units to Map units
      pMapTransformation.TransformRect pEnv, Rect, esriTransformToMap + esriTransformPosition
      
      'Get a cursor on features intersecting cell
      Set pGeometry = pEnv
      Set pFeatureCursor = SearchFeatureLayer(pFeatureLayer, pGeometry, esriSpatialRelIntersects)
      
      'Index these features
      AddFeatureIndexForCell pFeatureCursor, lField, sCell, rsIndex
    Next nRow
  Next nCol
  
  Set GetIndexForFeatureLayer = rsIndex
  
End Function

Public Function SearchFeatureLayer(pFeatureLayer As esriCore.IFeatureLayer, _
                             searchGeometry As esriCore.IGeometry, _
                             spatialRelation As esriCore.esriSpatialRelEnum, _
                             Optional whereClause As String = "" _
                             ) As esriCore.IFeatureCursor

  Dim pSpatialFilter As esriCore.ISpatialFilter
  Dim pFeatureCursor As esriCore.IFeatureCursor

  'Create a spatial query filter
  Set pSpatialFilter = New esriCore.SpatialFilter

  'Set spatial filter properties
  Dim pFeatureClass As IFeatureClass
  Set pFeatureClass = pFeatureLayer.FeatureClass
  pSpatialFilter.GeometryField = pFeatureClass.ShapeFieldName
  Set pSpatialFilter.Geometry = searchGeometry
  pSpatialFilter.SpatialRel = spatialRelation
  pSpatialFilter.whereClause = whereClause

  'Perform the query and get the resulting cursor
  Set pFeatureCursor = pFeatureLayer.Search(pSpatialFilter, True)

  'Return cursor
  Set SearchFeatureLayer = pFeatureCursor

End Function

Private Sub AddFeatureIndexForCell(pFeatureCursor As IFeatureCursor, lField As Long, sCell As String, ByRef rs As ADODB.Recordset)
  Dim pFeature As IFeature
  Set pFeature = pFeatureCursor.NextFeature
    
  Dim sFieldValue As String, sMultiple As String
  Do While Not pFeature Is Nothing
    sFieldValue = pFeature.Value(lField)
    If Trim(sFieldValue) = "" Then Exit Do
    If Not rs.BOF Then rs.MoveFirst
    rs.Find "DisplayField = '" & sFieldValue & "'"
    If rs.EOF Then
      rs.AddNew
      rs("Index") = sCell
      rs("DisplayField") = sFieldValue
    Else
      sMultiple = VBA.Trim(rs("Index")) & ", " & sCell
      If (VBA.Len(sMultiple) < rs!Index.DefinedSize) Then _
        rs("Index") = sMultiple
    End If
    Set pFeature = pFeatureCursor.NextFeature
  Loop
End Sub

Private Sub cmdOK_Click()
  Unload Me
End Sub


