VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmIndexFeatureLayer 
   Caption         =   "Create an Index for the Selected Feature Layer"
   ClientHeight    =   7245
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6435
   OleObjectBlob   =   "frmIndexFeatureLayer.frx":0000
   ShowModal       =   0   'False
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmIndexFeatureLayer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'******************************************************************************
'* This script makes IndexGrid A-H, 1-7
'*
'*
'*

Option Explicit


Private Sub cmdCreateIndex_Click()
  'Get the active views
  Dim pMxDoc As IMxDocument
  Dim pMap As IMap
  Set pMxDoc = ThisDocument
  Set pMap = pMxDoc.FocusMap
  
  'Get Selected layer
  Dim pFeatureLayer As IFeatureLayer
  If pMxDoc.SelectedLayer Is Nothing Then
    MsgBox "There is not selected layer.", vbExclamation + vbOKOnly
    Exit Sub
  Else
    If Not TypeOf pMxDoc.SelectedLayer Is IFeatureLayer Then
      MsgBox "Selected layer is not a feature layer.", vbExclamation + vbOKOnly
      Exit Sub
    End If
  End If
  Set pFeatureLayer = pMxDoc.SelectedLayer
  
  'Does user realy process unvisible layer?
  If pMxDoc.SelectedLayer.Visible = False Then
    If vbCancel = MsgBox("Selected layer is not visible. Are you sure to continue?", vbExclamation + vbOKCancel) Then Exit Sub
  End If
  
  'Create Index grid and add to layout
  Dim pGraphicsContainer As IGraphicsContainer
  Dim pMapFrame As IMapFrame
  Dim pLayoutView As IActiveView
  Dim pIndexGrid As IIndexGrid
  Set pGraphicsContainer = pMxDoc.PageLayout
  Set pMapFrame = pGraphicsContainer.FindFrame(pMap)
  Set pLayoutView = pMxDoc.PageLayout
  Set pIndexGrid = CreateAndAddIndexGrid(pMapFrame, pLayoutView)
  pIndexGrid.ColumnCount = 8
  pIndexGrid.RowCount = 7
  pIndexGrid.XLabel(6) = "G"
  pIndexGrid.XLabel(7) = "H"
  
  'Get the Index for this layer
  Dim rsIndex As ADODB.Recordset
  Set rsIndex = GetIndexForFeatureLayer(pFeatureLayer, pIndexGrid)
  
  'Populate listbox from recordset
  lstIndex.Clear
  rsIndex.Sort = "DisplayField, Index"
  rsIndex.MoveFirst
  Do While Not rsIndex.EOF
    lstIndex.AddItem rsIndex("DisplayField") & vbTab & rsIndex("Index"), lstIndex.ListCount
    rsIndex.MoveNext
  Loop
  rsIndex.Close
End Sub

Private Function CreateAndAddIndexGrid(pMapFrame As IMapFrame, pActiveView As IActiveView) As IIndexGrid
  'Create map grid
  Dim pMapGridFactory As IMapGridFactory
  Dim pIndexGrid As IIndexGrid
  Set pMapGridFactory = New IndexGridFactory
  Set pIndexGrid = pMapGridFactory.Create(pMapFrame)
  
  'Modify grid label font size and thickness
  Dim pIndexGridTabStyle As IIndexGridTabStyle
  Set pIndexGridTabStyle = pIndexGrid.LabelFormat
  pIndexGridTabStyle.Thickness = 10

  'Add map grid to Layout and refresh
  Dim pMapGrids As IMapGrids
  Set pMapGrids = pMapFrame
  pMapGrids.AddMapGrid pIndexGrid
  pActiveView.PartialRefresh esriViewBackground, Nothing, Nothing
  
  Set CreateAndAddIndexGrid = pIndexGrid
End Function

Private Function GetIndexForFeatureLayer(pFeatureLayer As IFeatureLayer, _
                              pIndexGrid As IIndexGrid) As ADODB.Recordset
  'Get the active views and the map frame
  Dim pMxDoc As IMxDocument
  Dim pMap As IMap
  Dim pLayoutView As IActiveView
  Dim pMapView As IActiveView
  Dim pGraphicsContainer As IGraphicsContainer
  Dim pMapFrame As IMapFrame
  Set pMxDoc = ThisDocument
  Set pMap = pMxDoc.FocusMap
  Set pLayoutView = pMxDoc.PageLayout
  Set pMapView = pMap
  Set pGraphicsContainer = pMxDoc.PageLayout
  Set pMapFrame = pGraphicsContainer.FindFrame(pMap)
  
  'Get the display transformations
  Dim pPageTransformation As IDisplayTransformation
  Dim pMapTransformation As IDisplayTransformation
  Set pPageTransformation = pLayoutView.ScreenDisplay.DisplayTransformation
  Set pMapTransformation = pMapView.ScreenDisplay.DisplayTransformation
    
  'Get the display field of the layer
  Dim pClass As IClass
  Dim lField As Long, sField As String
  Dim lFieldShow As Long, sFieldShow As String
  Set pClass = pFeatureLayer.FeatureClass
  
  ' pedpokldm, e OID mus existovat u feature class a je jednoznan
  ' ukldm do index
  sField = pClass.OIDFieldName
  lField = pClass.FindField(sField)
  ' etezec, kter se zobraz
  sFieldShow = pFeatureLayer.displayField
  lFieldShow = pClass.FindField(sFieldShow)

  'Create a recordset to hold the index
  Dim rsIndex As New ADODB.Recordset
  ' etzec mapovho rmce
  rsIndex.Fields.Append "Index", ADODB.adChar, 40
  ' to, k emu se to m zobrazit (vesnice, ulice)
  rsIndex.Fields.Append "DisplayField", ADODB.adChar, 50
  ' a samozejm index-OID, protoe ten idiot u obsadil pole index :(, dle kterho budeme vyhledvat
  rsIndex.Fields.Append "OID", ADODB.adInteger
  rsIndex.Open
  
  'Loop through the cells of the grid
  Dim nRow As Integer, nCol As Integer
  Dim sCell As String
  Dim pGeometry As IGeometry, pEnv As IEnvelope, Rect As tagRECT
  Dim pFeatureCursor As IFeatureCursor, pFeature As IFeature
'  Set pEnv = New Envelope ... we must create new object in each loop because of problem with S-JTSK
  For nCol = 0 To (pIndexGrid.ColumnCount - 1)
    For nRow = 0 To (pIndexGrid.RowCount - 1)
      'Cell name, e.g., "A-1"
      sCell = pIndexGrid.XLabel(nCol) & "-" & pIndexGrid.YLabel(nRow)
      Set pEnv = New Envelope
      
      'Get cell extent envelope
      pIndexGrid.QueryCellExtent nRow, nCol, pMapFrame, pEnv
      'Transform envelope from page to map coordinates
      '  Transform from Page units to Device units
      pPageTransformation.TransformRect pEnv, Rect, esriTransformToDevice + esriTransformPosition
      '  Transform from Device units to Map units
      pMapTransformation.TransformRect pEnv, Rect, esriTransformToMap + esriTransformPosition
      
      'Get a cursor on features intersecting cell
      Set pGeometry = pEnv
      Set pFeatureCursor = SearchFeatureLayer(pFeatureLayer, pGeometry, esriSpatialRelIntersects)
      
      'Index these features
      AddFeatureIndexForCell pFeatureCursor, lField, lFieldShow, sCell, rsIndex
    
      Set pEnv = Nothing
    Next nRow
  Next nCol
  
  Set GetIndexForFeatureLayer = rsIndex
  
End Function

Public Function SearchFeatureLayer(pFeatureLayer As esriCarto.IFeatureLayer, _
                             searchGeometry As esriGeometry.IGeometry, _
                             spatialRelation As esriGeoDatabase.esriSpatialRelEnum, _
                             Optional whereClause As String = "" _
                             ) As esriGeoDatabase.IFeatureCursor

  Dim pSpatialFilter As esriGeoDatabase.ISpatialFilter
  Dim pFeatureCursor As esriGeoDatabase.IFeatureCursor

  'Create a spatial query filter
  Set pSpatialFilter = New esriGeoDatabase.SpatialFilter

  'Set spatial filter properties
  Dim pFeatureClass As IFeatureClass
  Set pFeatureClass = pFeatureLayer.FeatureClass
  pSpatialFilter.GeometryField = pFeatureClass.ShapeFieldName
  Set pSpatialFilter.Geometry = searchGeometry
  pSpatialFilter.SpatialRel = spatialRelation
  pSpatialFilter.whereClause = whereClause

  'Perform the query and get the resulting cursor
  Set pFeatureCursor = pFeatureLayer.Search(pSpatialFilter, True)

  'Return cursor
  Set SearchFeatureLayer = pFeatureCursor

End Function

Private Sub AddFeatureIndexForCell(pFeatureCursor As IFeatureCursor, lField As Long, lFieldShow As Long, sCell As String, ByRef rs As ADODB.Recordset)
  Dim pFeature As IFeature
  Set pFeature = pFeatureCursor.NextFeature
  
  Dim sFieldValue As String, sMultiple As String
  Do While Not pFeature Is Nothing
    ' search by OID value
    sFieldValue = pFeature.Value(lField)
    
    If Trim(sFieldValue) = "" Then Exit Do
    If Not rs.BOF Then rs.MoveFirst
        ' search by OID in rs
        rs.Find "OID = '" & pFeature.Value(lField) & "'"
        If rs.EOF Then
          ' first occurence
          rs.AddNew
          rs("Index") = sCell
          rs("OID") = sFieldValue
          rs("DisplayField") = pFeature.Value(lFieldShow)
        Else
          ' next occurence
          sMultiple = VBA.Trim(rs("Index")) & ", " & sCell
          If (VBA.Len(sMultiple) < rs!Index.DefinedSize) Then _
            rs("Index") = sMultiple
    End If
    Set pFeature = pFeatureCursor.NextFeature
  Loop
End Sub

Private Sub cmdOK_Click()
  Unload Me
End Sub


Private Sub cmdSave_Click()
    Dim FileName As String
    FileName = InputBox("Enter file name", "Saving Index Grid", "IndexGrid.txt")
    If FileName = "" Then Exit Sub
    On Error GoTo err
    Open GetDocPath(Application) & FileName For Output Access Write Lock Write As #1
    
    Dim i As Long
    For i = 0 To lstIndex.ListCount - 1
        Print #1, lstIndex.List(i, 0)
    Next i
    Close #1
    Exit Sub
err:
    Close #1
    Call MsgBox("File save error!")
End Sub


Public Function GetDocPath(pApp As IApplication) As String
'******************************************************************************
'* Returns path to the current document ended by "\"
'******************************************************************************

  Dim pTemplates As ITemplates
  Dim lTempCount As Long
  Dim DocPath As String
  
  Set pTemplates = pApp.Templates
  lTempCount = pTemplates.Count
    
  ' The document is always the last item
  DocPath = pTemplates.Item(lTempCount - 1)
  
  If Len(DocPath) = 0 Then GetDocPath = "": Exit Function
  Dim i As Integer
  For i = Len(DocPath) To 0 Step -1
    If Mid(DocPath, i, 1) = "\" Then Exit For
  Next i
  GetDocPath = Left(DocPath, i)
End Function

