# Prevod souradnic v zemepisnych souradnicich z tvaru SMV na SS.sssssss
# napr.: 15 30'00.0" na 15.5
# znaky pro oddeleni stupnu, minut a vterin se zadavaji jako vstupni parametry
# Navic pred souradnici nebo za ni muze byt oznaceni sever/jih resp. vychod/zapad
# toto oznaceni muze byt 'N','S' resp. 'E','W', nebo 'S','J' resp. 'V','Z'
# a muze se vyskytovat pred souradnici nebo za ni
# (E15 30' 00.0" nebo 15 30' 00.0"E)

# Nasledujici skript dela:
# Ze vstupniho textoveho souboru vytvori pracovni textovy soubor, kde jsou
# zemepisne souradnice prevedeny na desetinny tvar. Tento soubor je pomoci
# nastroje MakeXYEventLayer importovan do ArcGIS a ulozen jako vystupni trida prvku.
# Nazvy poli se souradnicemi si skript vezme ze vstupnich argumentu stejne jako znaky
# pro oddelovace poli, stupnu, minut a vterin. Eventualni oznaceni N-S/E-W prip. S-J/V-Z
# v obsahu souradnicovych poli skript pozna sam. Pokud se oddelovac poli nachazi i v jejich
# obsahu jako retezec, musi byt tento retezec v uvozovkach.
# Skript dale kontroluje, zda pri ukladani do datove sady souhlasi souradnicovy system.

# Autor: Vladimir Zenkl, ARCDATA PRAHA, s.r.o.
# Verze 2, posledni revize 9. 3. 2010


#--------------------------------------------------------------------------------------
#Import system modules
import arcgisscripting, sys, string, os
gp = arcgisscripting.create()

stavovy_kod = 4

def zprava(massage,s=0):
    """(retezec,uroven) -> hlaseni do Python Shellu a do Okna ArcGISu"""
    print massage
    if massage != "":
        if s == 2:
            gp.AddError(massage)
        elif s == 1:
            gp.AddWarning(massage)
        else:
            gp.AddMessage(massage)
    # end zprava()

def mezery(r):
    """Orizne mezery zleva a zprava a uvnitr nahradi vice sousedicich mezer jednou mezerou
       '  a b    c     ' -> 'a b c'"""
    r = r.strip()
    r1 = r.replace("  "," ")
    while r1 <> r:
        r = r1
        r1 = r.replace("  "," ")
    return(r1)
    # end mezery()


def ctiparam(param):
    """Precteni a test vstupnich parametru."""
    vstup = param[1]      # vstupni textovy soubor
                          # typ parametru: string (toolbox: Soubor)
                          # povinny, default: neni

    #Kontrola zda soubor existuje
    if ((os.path.exists(vstup)==False) or (os.path.isfile(vstup)==False)):
        raise "FileMissing"

    vystup = param[2]     # vystupni trida prvku - trida prvku
                          # typ parametru: string (toolbox: Trida prvku)
                          # povinny, default: neni
                          
    poleZD = param[3]     # pole se zemepisnou sirkou (souradnici Y) - retezec
                          # typ parametru: string (toolbox: String)
                          # povinny, default: neni

    poleZS = param[4]     # pole se zemepisnou delkou (souradnici X) - retezec
                          # typ parametru: string (toolbox: String)
                          # povinny, default: neni

    if param[5] == "#":              # souradnicovy system
        soursys = ""                 # typ parametru: string (toolbox: spatial reference)
    else:                            # nepovinny, default: "" (jako argument pythonu: #)
        soursys = param[5] # pokud je zadan, nacita se jako objekt

    #Kontrola zda souhlasi Spatial Reference (pouze pri ukladani do datove sady)
    cil = gp.Describe(os.path.dirname(vystup))
    if cil.DataType == "FeatureDataset":
        if soursys == "":
            raise "SpRefMissing"
        elif soursys.Name != cil.SpatialReference.Name:
            raise "SpRefError"    

    op = param[6]     # oddelovac polozek (retezec)
                      # typ parametru: string (toolbox: String)
                      # nepovinny, default: "carka"
                      # preddefinovane moznosti: "mezery", "carka", "strednik", "tabelator"
                      # nebo zadat primo samotny znak, napr. " ", nebo i jiny, napr. "@",
                      # take lze zadat sekvenci vice znaku, napr. pro radek ve tvaru
                      # 1--15.2345--49.4562--A
                      # zadame op = "--"
                      # Pozor: pripadne mezery kolem zadaneho oddelovace se nespecifikuji,
                      # jsou odstraneny automaticky, napr. pro radek
                      # 1,  15.2345,  49.4562,  A
                      # specifikujeme op = ","
    if op == "" or op == "#":
        op = ","      # vychozi oddelovac polozek je carka

    # Prevod vstup. argumentu na skutecny znak oddelovace. Pocita se s argumenty
    # "mezera", "carka", "strednik", "tabelator", v jinem pripade je znak ponechan
    if op.lower().startswith("m"):
        op = " "
    elif op.lower().startswith("c"):
        op = ","
    elif op.lower().startswith("s"):
        op = ";"
    elif op.lower().startswith("t"):
        op = "\t"

    od = param[7]     # desetinny oddelovac (retezec)
                      # typ parametru: string (toolbox: String)
                      # nepovinny, default: "."
                      # poznamka: Python pracuje s desetinnym oddelovacem
                      # tecka (carka je oddelovac polozek seznamu)
                      # proto je potreba pred prevodem retezce na cislo
                      # pripadnou desetinnou carku prevest na tecku. Napr.:
                      #  a = "1,2"
                      #  if od == ",":
                      #      a = float(string.replace(a,",","."))
    if od == "" or od == "#":
        od = "."
    else:
        od = od[0]

    if od.lower() == "t":
        od = "."
    elif od.lower() == "c":
        od = ","
    if od not in [".",","]:
        raise "chyba_des_odd"

    ost = param[8]                 # oznaceni (oddelovac) stupnu (cislo - ASCII kod znaku)
    if ost == "" or ost == "#":    # typ parametru: integer (toolbox: integer - long)
        ost = chr(176)             # nepovinny, default: 176 (znak stupnu)
    elif ost[0].lower() == "m":
        ost = " "
    else:
        ost = ost[0]

    om = param[9]                  # oznaceni (oddelovac) minut (cislo - ASCII kod znaku)
    if om == "" or om == "#":      # typ parametru: integer (toolbox: integer - long)
        om = chr(39)                    # nepovinny, default: 39 (apostrof)
    elif om[0].lower() == "m":
        om = " "
    else:
        om = om[0]

    ov = param[10]                 # oznaceni (oddelovac) vterin (cislo - ASCII kod znaku)
    if ov == "" or ov == "#":      # typ parametru: integer (toolbox: integer - long)
        ov = chr(34)                    # nepovinny, default: 34 (uvozovky)
    elif ov[0].lower() == "m":
        ov = " "
    else:
        ov = ov[0]

    typgeom = param[11].upper()    # typ geometrie vystupni FC ['POINT','MULTIPOINT','POLYGON','POLYLINE']
    if typgeom == "" or typgeom == "#":
        typgeom == "POINT"
    if not typgeom in ['POINT','MULTIPOINT','POLYGON','POLYLINE']:
        raise "chyba_typgeom"

    idline = param[12]             # pole, oznacujici body, tvorici jednu linii nebo polygon
                                   # povinny parametr v pripade, ze typgeom je Polyline nebo Polygon
                                   # typ parametru: string (toolbox: string)
                                   # defaul: neni
    if idline == '#' or idline == '':
        idline == ''
    if idline == '' and typgeom in ['POLYLINE','POLYGON']:
        raise "chyba_idline"

    return(vstup,vystup,poleZS,poleZD,soursys,op,od,ost,om,ov,typgeom,idline)
    # end ctiparam()

def cestajmenokoncovka(jmeno_souboru):
    """jmeno souboru s cestou -> (cesta,jmeno_souboru_bez_koncovky,koncovka_vcetne_tecky)"""
    # napr.:
    # "c:\\student\\data\\abc.def.ghi.jkl" -> ("c:\\student\\data","abc.def.ghi",".jkl")
    # "abcd" -> ("","abcd","")
    
    import os,string
    if jmeno_souboru.find(os.sep) > -1:
        cesta = os.path.dirname(jmeno_souboru)
    else:
        cesta = ""
    pom = os.path.basename(jmeno_souboru)
    if pom.find(".") > -1:
        pom = pom.split(".")
        koncovka = "." + pom[len(pom)-1]
        jmeno = string.join(pom[:-1],".")
    else:
        jmeno = pom
        koncovka = ""
    return (cesta,jmeno,koncovka)
    # end cestajmenokoncovka()

def jmena_poli(radek,op,poleY,poleX,idline):
    """jmena_poli(radek,op,pZS,pZD) -> [polozky],py,px"""
    radek = radek.replace("\n","")
    radek = radek.rstrip()

    if op == " ":
        radek = mezery(radek)
    polozky = radek.split(op)
    if op == ",":
        for q in range(len(polozky)):
            # za carkou by mohla byt jeste jedna nebo vice mezer, ty odstranime:
            polozky[q] = polozky[q].lstrip()
    px = -1
    if poleX in polozky:
        px = polozky.index(poleX)
    py = -1
    if poleY in polozky:
        py = polozky.index(poleY)
    pidline = -1
    if idline != '' and idline in polozky:
        pidline = polozky.index(idline)

    return (polozky,py,px,pidline)
    # end jmena_poli()

def smv2dd(smv,ost,omi,ovt,odes):
    """prevod retezce s cislem ve tvaru stupne minuty vteriny (SS<ost>MM<omi>VV.vvv<ovt>)
na desetinne stupne.
smv2dd(retezec, oznaceni_stupnu, oznaceni_minut, oznaceni_vterin, znak_pro_desetinnou_carku)
-> desetinne cislo (type:float)"""
    st = 0.0
    mi = 0.0
    vt = 0.0
    
    znamenko = 1.0
    if smv.find('W')> -1 or smv.find('S') > -1:
        znamenko = -1.0

    if odes == ',':
        smv = smv.replace(',','.')

    smv = smv.replace('N','')
    smv = smv.replace('E','')
    smv = smv.replace('S','')
    smv = smv.replace('W','')

    flg = False
    
    ist = smv.find(ost)
    if ist > -1:
        st = smv[:ist].strip()
        smv = smv[ist+1:]
    elif ost == ' ':
        st = smv
        flg = True
        smv = ''

    imi = smv.find(omi)
    if imi > -1:
        mi = smv[:imi].strip()
        smv = smv[imi+1:]
    elif omi == ' ' and not flg:
        mi = smv
        flg = True
        smv = ''

    ivt = smv.find(ovt)
    if ivt > -1:
        vt = smv[:ivt].strip()
        smv = smv[ivt+1:]
    elif ovt == ' ' and not flg:
        vt = smv
        
    if ist == -1 and imi == -1 and ivt == -1 and not flg:
        st = smv.strip()

    return (float(st) + float(mi)/60.0 + float(vt)/3600.0) * znamenko
    # end smv2dd()

def testcislo(r,od):
    """(retezec,desetinny_oddelovac) -> typ
    typ: 'LONG', 'DOUBLE', 'TEXT'"""
    import string
    cislo = True
    z_od = False
    typcis = "LONG"
    for znak in r:
        if znak not in string.digits:
            if znak == od:
                if z_od == True:
                    typcis = "TEXT"
                    break
                else:
                    z_od = True
                    typcis = "FLOAT"
            else:
                typcis = "TEXT"
                break
    return typcis

def rozeber_radek(r,op,ov,ix,iy):
    """(radek,oddelovac_polozek,odznaceni_vterin,
    index_polozkyX,index_polozkyY) -> [zaznam]"""
    ix = 1
    iy = 2
    ov = '"'
    if op == " ":
        if r.endswith('\n'):
            r = r[:-1]
        r.strip()

        sezpol = []
        ipol = 0
        pol = ''
        uvoz = False
        predchazejici = ''
        zapsano = False
        i = 0
        while i < len(r)-1:
            if r[i] == '"':
                if (ipol == ix or ipol == iy):
                    if pol == "":
                        i += 1
                        while r[i] != '"':
                            pol += r[i]
                            i += 1
                        if ov == '"':
                            pol += r[i]
                            i += 1
                            while r[i] != '"':
                                pol += r[i]
                                i += 1
                    else:
                        if ov == '"':
                            pol += r[i]
                            i += 1
                            while r[i] != ' ':
                                pol += r[i]
                                i += 1
                    zapsano = False
                    uvoz = False
                else:
                    if uvoz == False:
                        uvoz = True
                        uvozac = True
                    else:
                        if r[i+1] == '"':
                            pol += r[i]
                            i += 1
                        elif r[i+1] == ' ':
                            uvozac = False
                            sezpol.append(pol)
                            zapsano = True
                            pol = ""
                            ipol += 1
                            uvoz = False
                            i += 1
                            while r[i] == ' ':
                                i += 1
                            i -= 1
                        elif r[i-1] == '"':
                            pol += r[i]
            if r[i] == " ":
                if uvoz == True:
                    pol += r[i]
                    zapsano = False
                else:
                    if zapsano == False:
                        sezpol.append(pol)
                        ipol += 1
                        pol = ""
                        
                    while r[i] == ' ':
                        i += 1
                    i -= 1
            if r[i] != ' ' and r[i] != '"':
                pol += r[i]
                zapsano = False
            i += 1
 
        if zapsano == False:
            if r[-1] != '"':
                pol += r[-1]
            sezpol.append(pol)

    else:
        sezpol = r.split(op)
        for ip in range(len(sezpol)):
            if sezpol[ip].endswith('\n'):
                sezpol[ip] = sezpol[ip][:-1]
            if sezpol[ip].startswith('"') and sezpol[ip].endswith('"'):
                sezpol[ip] = sezpol[ip][1:-1]
            sezpol[ip] = sezpol[ip].replace('""','"')

    return sezpol
    # end rozeber_radek()



########################################################################################################################
########################################################################################################################                   
# Z P R A C O V A N I :

try:
    vystup_vytvoren = "ne"
    
    #-------------------------------------------------------------------------------------------------------------------
    # Nacteni parametru:
    zprava("Nacteni parametru...")
    vstup,vystup,poleZS,poleZD,soursys,op,od,ost,om,ov,typgeom,idline = ctiparam(sys.argv)

    #-------------------------------------------------------------------------------------------------------------------
    # Kontrola a uprava nazvu a umisteni vstupu a vystupu:
    zprava("Kontrola a uprava nazvu a umisteni vstupu a vystupu...")
    vstup_c,vstup_j,vstup_k = cestajmenokoncovka(vstup)

    if vystup == "" or vystup == "#":
        vystup_c = ""
        vystup_j = vstup_j
        vystup_k = ""
    else:
        vystup_c,vystup_j,vystup_k = cestajmenokoncovka(vystup)

    if not vstup_c:
        if not gp.workspace:
            raise "neznam_cestu"
        else:
            vstup_c = gp.workspace

    if not vystup_c:
        if gp.workspace:
            vystup_c = gp.workspace
        else:
            vystup_c = vstup_c

    vystup_v = gp.ValidateTablename(vystup_j,vystup_c)
    if vystup_v != vystup_j:
        zprava("\nPOZOR: zadane jmeno vystupu je neplatne pro dany workspace.",1)
        zprava("Bylo automaticky upraveno!",1) 
    vystup = vystup_c + os.path.sep + vystup_v
    zprava("Finalni podoba jmena vystupu:",1)
    zprava(vystup + "\n",1)
        
    # ------------------------------------------------------------------------------------------------------------------
    # Analyza vstupniho textoveho souboru:
    zprava("Analyza vstupniho textoveho souboru...")
    fin = open(vstup,"r")

    # Z prvniho nacteneho radku udelat seznam poli
    zpracovavam = 1
    radek = fin.readline()
    
    polozky,iy,ix,iidline = jmena_poli(radek,op,poleZS,poleZD,idline)
    if iy == -1 or ix == -1:
        raise "chyba_poleXY"
    if typgeom in ['POLYLINE','POLYGON'] and iidline == -1:
        raise "chyba_idline"

    # Test nazvu poli:
    zprava("Test nazvu poli...")
    nazvypoli = []
    for q in range(0,len(polozky)):
        polozky[q] = polozky[q].strip()  #orezani mezer v nazvech poli
        nazvypoli.append(gp.ValidateFieldName(polozky[q],os.path.dirname(vystup)))
        if nazvypoli[q] <> polozky[q]:
            zprava("Nazev pole uvedeny v textovem souboru je neplatny pro cilovou tridu prvku:",1)
            zprava("  - misto nazvu pole " + polozky[q].upper() + " je pouzit nazev " + nazvypoli[q].upper() + "\n",1)
    polozky = nazvypoli

    # Zjisteni typu a delky atributovych poli v textovem souboru:
    zprava("Zjisteni typu a delky atributovych poli v textovem souboru...")
    zalozpole = [] # bude zde: [[nazev_polozky,typ_polozky,delka_polozky],...]
    for i in range(len(polozky)):
        if i == ix or i == iy:
            zalozpole.append(["","",0])
        else:
            zalozpole.append([polozky[i],"LONG",0])
    zpracovavam += 1
    radek = fin.readline()
    if not radek.endswith("\n"):
        radek += "\n"
    while radek:
        test = rozeber_radek(radek,op,ov,ix,iy)
        if len(test) > len(polozky):
            raise "pocet_polozek"
        for ipt in range(len(test)):
            if ipt != ix and ipt != iy:
                zalozpole[ipt][2] = max(len(test[ipt]),zalozpole[ipt][2])
                typ = testcislo(test[ipt],od)
                if zalozpole[ipt][1] == "LONG":
                    if typ == "DOUBLE":
                        zalozpole[ipt][1] = "DOUBLE"
                    elif typ == "TEXT":
                        zalozpole[ipt][1] = "TEXT"
                elif zalozpole[ipt][1] == "DOUBLE":
                    if typ == "TEXT":
                        zalozpole[ipt][1] = "TEXT"
        zpracovavam += 1
        radek = fin.readline()
    fin.close()
    
    # Zalozeni vystupni tridy prvku (bez atributovych poli):
    zprava("Zalozeni vystupni tridy prvku (bez atributovych poli)...")
    vysledek = gp.CreateFeatureClass_management(vystup_c, vystup_v, typgeom, "", "", "", soursys)

    # Pridani atributovych poli do nove tridy prvku:
    zprava("Pridani atributovych poli do nove tridy prvku...")
    typwksp = gp.Describe(vystup_c).WorkspaceType
    zprava(typwksp,1)
    if typwksp == "FileSystem" and not vystup.endswith(".shp"):
        vystup = vystup + ".shp"
    for ip in range(len(zalozpole)):
        if ip != ix and ip != iy:
            if zalozpole[ip][1] == 'TEXT':
               zprava("Pridani pole %s..." % zalozpole[ip][0],1)
               gp.AddField_management(vystup,zalozpole[ip][0],zalozpole[ip][1],"","",zalozpole[ip][2])
            elif zalozpole[ip][1] != '':
               zprava("Pridani pole %s..." % zalozpole[ip][0],1)
               gp.AddField_management(vystup,zalozpole[ip][0],zalozpole[ip][1])

    # Zjisteni jmena pole s geometrii v nove tride prvku:
    zprava("Zjisteni jmena pole s geometrii v nove tride prvku...")
    jmenopoleshape = gp.Describe(vystup).ShapeFieldName

    # Priprava pro zpracovani:
    zprava("Priprava pro zpracovani...")
    geom_bod     = gp.CreateObject("point") # bod
    geom_linie   = gp.CreateObject("array") # pripraveno pro linie
    geom_polygon = gp.CreateObject("array") # pripraveno pro polygony

    ####################################################################################################################
    ####################################################################################################################
    # V PRIPADE POTREBY UPRAVIT SKRIPT, NAPRIKLAD PRO ZPRACOVANI LINII,
    # je treba upravit pouze tuto cast:
    zprava("Zpracovani...")
    cur = gp.InsertCursor(vystup)  # vytvoreni kurzoru
    zpracovavam = 0    
    fin = open(vstup,"r") # znovu otevreni vstupniho souboru
    zpracovavam = 0
    radek = fin.readline() # preskoceni prvniho radku (jsou to jiz zpracovane nazvy poli)
    # Zpracovani radku s daty:
    zpracovavam += 1
    radek = fin.readline()
    while radek:
        # zpracovani radku textoveho souboru:
        zaznam = rozeber_radek(radek,op,ov,ix,iy)
        row = cur.NewRow()
        # souradnice bodu:
        geom_bod.x = smv2dd(zaznam[ix],ost,om,ov,od)
        geom_bod.y = smv2dd(zaznam[iy],ost,om,ov,od)
        row.SetValue(jmenopoleshape,geom_bod)
        # atributy (bez polozek se souradnicemi):
        for ip in range(len(zaznam)):
            if ip != ix and ip != iy and zalozpole[ip][1]:
                if zalozpole[ip][1] == "DOUBLE" and od == ",":
                    zaznam[ip] = zaznam[ip].replace(",",".")
                    row.SetValue(zalozpole[ip][0],float(zaznam[ip]))
                elif zalozpole[ip][1] == "LONG":
                    row.SetValue(zalozpole[ip][0],int(zaznam[ip]))
                elif zalozpole[ip][1] == "TEXT":
                    row.SetValue(zalozpole[ip][0],zaznam[ip])
        cur.InsertRow(row)
        zpracovavam += 1
        radek = fin.readline()
    zprava("Pocet zpracovanych radku se souradnicemi = " + str(zpracovavam))
    fin.close()
    del cur
    del row

    vystup_vytvoren = ""

    # konec useku, ktery je treba upravit
    ####################################################################################################################
    ####################################################################################################################
        
    zprava("Hotovo.")
    
#=======================================================================================================================
    
except "neznam_cestu":
    zprava("Pro vstup nebyla zadana cesta a workspace v toolboxu neni nastaven!",2)
    stavovy_kod = 5

except "FileMissing":
    zprava("Vstupni soubor nenalezen!",2)
    stavovy_kod = 5

except "chyba_poleXY":
    if ix == -1:
        zprava("Zadany nazev %s pro pole se zem. sirkou (souradnici Y) se nevyskytuje v 1. radku souboru!" % (poleZS),2) 
    if iy == -1:
        zprava("Zadany nazev %s pro pole se zem. delkou (souradnici X) se nevyskytuje v 1. radku souboru!" % (poleZD),2)
    zprava("Prvni radek souboru:",1)
    zprava(string.join(polozky," "),1)
    stavovy_kod = 5

except "chyba_idline":
    zprava("Zadany nazev %s pro pole oznacujici body patrici do stejne linie se nevyskytuje v 1. radku souboru!" % (idline),2) 
    zprava("Prvni radek souboru:",1)
    zprava(string.join(polozky," "),1)
    stavovy_kod = 5

except "pocet_polozek":
    zprava("CHYBA: radek c. " + str(zpracovavam) + " obsahuje vice polozek, nez je definovano v zahlavi!",2)
    stavovy_kod = 5

except "LongError":
    zprava("Pole se zemepisnou delkou nenalezeno!",2)
    stavovy_kod = 5

except "SpRefMissing":
    zprava("Pro zapis vystupu do datove sady v geodatabazi",2) 
    zprava("je treba zadat souradnicovy system (Spatial Reference) vstupnich dat!",2)
    stavovy_kod = 5

except "SpRefError":
    zprava("Souradnicovy system vstupu se neshoduje se souradnicovym systemem cilov datove sady!",2)
    zprava("TIP: nejprve ulozte vystup do samostatne tridy prvku v geodatabazi",1)
    zprava("a pak jej transformujte do souradnicoveho systemu datove sady nastrojem Project.",1)
    zprava("Viz ArcToolbox > Sprava dat > Souradnicove systemy a transformace > Vektorova data > Transformace...",1)
    zprava("(ArcToolbox > Data Management Tools > Projections and Transformations > Feature > Project)",1)
    stavovy_kod = 5

except "chyba_des_odd":
    zprava("Neplatny desetinny oddelovac.",2)
    stavovy_kod = 5
    
except "souradnice":
    zprava("Chyba ve vstupni souradnici.",2)
    zprava("Chyba nastala pri zpracovani radku c. " + str(zpracovavam) + " (prvni radek s nazvy poli na cislo 0).",0)
    stavovy_kod = 5

except "uvozovky":
    zprava("CHYBA: V polozce, ktera neni zemepisnou souradnici, se vyskytuje znak uvozovky.",2)
    stavovy_kod = 5

except:
    zprava("***** CHYBA ! *****")
    zprava(gp.GetMessages())
    zprava("Chyba vznikla pravdepodobne:")
    zprava("- nespravnym zadanim parametru")
    zprava("- chybou ve vstupnich datech")
    zprava("- pokusem o zpracovani souboru, jehoz struktura neni skriptem podporovana.")
    zprava("Chyba nastala pri zpracovani radku c. " + str(zpracovavam) + " (prvni radek s nazvy poli ma cislo 0).",0)
    stavovy_kod = 5

zprava("\nVystupni trida prvku " + vystup_vytvoren + "vytvorena.",1)    
if stavovy_kod <> 4:
    sys.exit(stavovy_kod)
