# Test importu textoveho souboru do bodove tridy prvku.
# Zaroven jsou zde priklady zadani parametru pro importni skript pro ruzne
# tvary textovych souboru.
# Autor: Ing. Vladimir Zenkl, ARCDATA PRAHA, s.r.o.

import arcgisscripting, sys, os.path
gp = arcgisscripting.create(9.3)
gp.overwriteoutput = True

kde = sys.argv[1] # kde jsou umstny testovac soubory
kam = sys.argv[2] # kam zapsat vysledky testu
tbx = sys.argv[3] # kde je toolbox s nastrojem pro import

gp.AddToolbox(os.path.join(tbx,"importxy.tbx"))
gp.Toolbox = ("impt")

# Toto je seznam stavovych kodu a jejich vyznamu vracenych nastrojem:
stav_orig = {0:"New",1:"Submitted",2:"Waiting",3:"Executing",4:"Succeeded.",5:"Failed ",
             6:"Timed Out",7:"Canceling",8:"Canceled.",9:"Deleting",10:"Deleted"}
# Tento kod lze zjistit prectenim vlastnosti objektu Result:
# vysledek = gp.nastroj(...)
# kod = vysledek.status
# vyznam stavovych kodu pro ucely tohoto skriptu:
stav = {0:"je nov loha.",1:"bylo odeslno ke zpracovn.",2:"ek.",3:"probh.",4:"probhlo spn.",5:"skonilo chybou.",
        6:"vyprel asov limit.",7:"je stornovvno.",8:"bylo stornovno.",9:"je odstraovno.",10:"bylo odstranno."}

# V teto ukazce jsou souradnicove systemy specifikovany pomoci svych kodu, tzv. "Factory code"
# WGS84, zemepisne souradnice: 4326
# WGS84, rovinne souradnice (UTM Zone33N): 32633
# S-JTSK, zemepisne souradnice: 4156
# S-JTSK, rovinne souradnice, zaporne a prohozene: 102067
# S-JTSK, rovinne souradnice, kladne a neprohozene: 102065
# Factory code sour. systemu lze zjistit bud z dokumentace (ProgramFiles\ArcGIS\Documentation),
# nebo skriptem ze tridy prvku, ktera ma sour. system jiz nastaveny:
# gp.AddMessage(gp.Describe(fc).SpatialReference.FactoryCode)


gp.AddMessage("test01")
# ID	B	L
# 101	5010'45,14"	1231'34,41"
# oddelovac polozek: tabelator, desetinny oddelovac: carka
# souradnice: zemepisne (stupne<> minuty<'> vteriny<">)
# souradnicovy system: WGS84, zemepisne souradnice
vstup = os.path.join(kde,"test01.txt")
vystup = os.path.join(kam,"test01")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"L","B",4326,"tabelator","carka")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test02")
# CIS	B	L	H1	H2
# 201	50 27 3.82	13 15 22.26	A	111
# oddelovac polozek: tabelator, desetinny oddelovac: tecka
# souradnice: zemepisne (stupne<mezera> minuty<mezera> vteriny)
# souradnicovy system: WGS84
vstup = os.path.join(kde,"test02.txt")
vystup = os.path.join(kam,"test02")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"L","B",4326,"tabelator",".","mezera","mezera ","mezera")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test03")
# CIS,B,L,H1,H2
# 301,5040'22.07"N,1431'24.545"E,A,111
# oddelovac polozek: carka, desetinny oddelovac: tecka
# souradnice: zemepisne (stupne<> minuty<'> vteriny<">)
# souradnicovy system: WGS84
vstup = os.path.join(kde,"test03.txt")
vystup = os.path.join(kam,"test03")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"L","B",4326,"carka","tecka")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test04")
# CIS   B              L              H1
# 401   50:22'52,621"  15:26'57,013"  A
# oddelovac polozek: mezery, desetinny oddelovac: carka
# souradnice: zemepisne (stupne<:> minuty<'> vteriny<">)
# souradnicovy system: WGS84
vstup = os.path.join(kde,"test04.txt")
vystup = os.path.join(kam,"test04")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"L","B",4326,"mezery","carka",":")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test05")
# CIS;B;L;H1;H2
# 501;49,736535;16,631423;;222
# oddelovac polozek: strednik, desetinny oddelovac: carka
# souradnice: zemepisne (desetinne stupne)
# souradnicovy system: WGS84
vstup = os.path.join(kde,"test05.txt")
vystup = os.path.join(kam,"test05")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"L","B",4326,"strednik",",")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test06")
# CIS,B,L,H1,H2
# 601,49.5,17.180926,C
# oddelovac polozek: carka, desetinny oddelovac: tecka
# souradnice: zemepisne (desetinne stupne)
# souradnicovy system: WGS84
vstup = os.path.join(kde,"test06.txt")
vystup = os.path.join(kam,"test06")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"L","B",4326,",",".")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test07")
# nzev	cp	X	Y
# Kostel sv. Mikule s hrobkou Vetter z Lilie, Albrechtiky	2	"49 42' 05.62"""	"18 05' 43.30"""
# (soubor vznikl exportem z programu Microsoft Excel do souboru CSV s oddlovaem poloek tabeltor)
# oddelovac polozek: tabelator, desetinny oddelovac: tecka
# souradnice: zemepisne (stupne<> minuty<'> vteriny<">)
# souradnicovy system: WGS84
vstup = os.path.join(kde,"test07.txt")
vystup = os.path.join(kam,"test07")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"Y","X",4326,"tab","tec")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test08")
# oddelovac polozek: carka, desetinny oddelovac: tecka
# souradnice: rovinne, S-JTSK, zaporne, prohozene
# prvni dva radky souboru:
# CIS, X,              Y
# 801, -540213.411617, -1164940.90506
vstup = os.path.join(kde,"test08.txt")
vystup = os.path.join(kam,"test08")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"X","Y",102067,",",".")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test09")
# X/Y/TYP/CISLO
# -595365,4/-1134343,3 / P / 901
# oddelovac polozek: lomitko, desetinny oddelovac: carka
# souradnice: rovinne, zaporne, prohozene
# souradnicovy system: S-JTSK
vstup = os.path.join(kde,"test09.txt")
vystup = os.path.join(kam,"test09")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"X","Y",102067,"/",",")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddMessage("test10")
# CIS,X,Y
# 1001,1102825.916,674127.905
# oddelovac polozek: carka, desetinny oddelovac: tecka
# souradnice: rovinne, kladne, neprohozene
# souradnicovy system S-JTSK
vstup = os.path.join(kde,"test10.txt")
vystup = os.path.join(kam,"test10")
gp.AddMessage(vstup)
gp.AddMessage(vystup)
vysledek = gp.importxy(vstup,vystup,"X","Y",102065,",",".")
gp.AddMessage("Zpracovani " + stav[vysledek.status])

gp.AddWarning("Konec testu.")
gp.AddWarning("Nyni vysledky pridejte do mapoveho dokumentu testimport.mxd.")
