# Prevod souradnic v zemepisnych souradnicich z tvaru SMV na SS.sssssss
# napr.: 15 30'00.0" na 15.5
# znaky pro oddeleni stupnu, minut a vterin se zadavaji jako vstupni parametry
# Navic pred souradnici nebo za ni muze byt oznaceni sever/jih resp. vychod/zapad
# toto oznaceni muze byt 'N','S' resp. 'E','W', nebo 'S','J' resp. 'V','Z'
# a muze se vyskytovat pred souradnici nebo za ni
# (E15 30' 00.0" nebo 15 30' 00.0"E)

# Nasledujici skript dela:
# Ze vstupniho textoveho souboru vytvori pracovni textovy soubor, kde jsou
# zemepisne souradnice prevedeny na desetinny tvar. Tento soubor je pomoci
# nastroje MakeXYEventLayer importovan do ArcGIS a ulozen jako vystupni trida prvku.
# Nazvy poli se souradnicemi si skript vezme ze vstupnich argumentu stejne jako znaky
# pro oddelovace poli, stupnu, minut a vterin. Eventualni oznaceni N-S/E-W prip. S-J/V-Z
# v obsahu souradnicovych poli skript pozna sam. Pokud se oddelovac poli nachazi i v jejich
# obsahu jako retezec, musi byt tento retezec v uvozovkach.
# Skript dale kontroluje, zda pri ukladani do datove sady souhlasi souradnicovy system.

# Autori: Marcel Sip, Vladimir Zenkl, ARCDATA PRAHA, s.r.o.
# Verze 1, posledni revize 18. 4. 2008

#--------------------------------------------------------------------------------------
#Import system modules
import sys, string, os, arcgisscripting

try:
    gp = arcgisscripting.create()

#--------------------------------------------------------------------------------------
# Nacteni parametru: 

    vstup = sys.argv[1]   # vstupni textovy soubor
                          # typ parametru: string (toolbox: Soubor)
                          # povinny, default: neni

    #Kontrola zda soubor existuje
    if ((os.path.exists(vstup)==False) or (os.path.isfile(vstup)==False)):
        raise "FileMissing"

    vystup = sys.argv[2]  # vystupni trida prvku - trida prvku
                          # typ parametru: string (toolbox: Trida prvku)
                          # povinny, default: neni

    poleZS = sys.argv[3]  # pole se zemepisnou sirkou (souradnici Y) - retezec
                          # typ parametru: string (toolbox: String)
                          # povinny, default: neni

    poleZD = sys.argv[4]  # pole se zemepisnou delkou (souradnici X) - retezec
                          # typ parametru: string (toolbox: String)
                          # povinny, default: neni

    if sys.argv[5] == "#":           # souradnicovy system
        soursys = ""                 # typ parametru: string (toolbox: spatial reference)
    else:                            # nepovinny, default: "" (jako argument pythonu: #)
        soursys = gp.GetParameter(4) # pokud je zadan, nacita se jako objekt

    #Kontrola zda souhlasi Spatial Reference (pouze pri ukladani do datove sady)
    cil = gp.Describe(os.path.dirname(vystup))
    if cil.DataType == "FeatureDataset":
        if soursys == "":
            raise "SpRefMissing"
        elif soursys.Name != cil.SpatialReference.Name:
            raise "SpRefError"    

    op = sys.argv[6]  # oddelovac polozek (retezec)
                      # typ parametru: string (toolbox: String)
                      # nepovinny, default: "carka"
                      # moznosti: "mezera", "carka", "strednik", "tabelator"
                      # nebo zadat primo samotny znak
    if op == "" or op == "#":
        op = ","

    # Prevod vstup. argumentu na skutecny znak oddelovace. Pocita se s argumenty
    # "mezera", "carka", "strednik", "tabelator", v jinem pripade je znak ponechan
    if op.startswith("m",0,1):
        op = " "
    elif op.startswith("c",0,1):
        op = ","
    elif op.startswith("s",0,1):
        op = ";"
    elif op.startswith("t",0,1):
        op = "\t"

    od = sys.argv[7]  # desetinny oddelovac (retezec)
                      # typ parametru: string (toolbox: String)
                      # nepovinny, default: "."
                      # poznamka: Python pracuje s desetinnym oddelovacem
                      # tecka (carka je oddelovac polozek seznamu)
                      # proto je potreba pred prevodem retezce na cislo
                      # pripadnou desetinnou carku prevest na tecku. Napr.:
                      #  a = "1,2"
                      #  if od == ",":
                      #      a = float(string.replace(a,",","."))
    if od == "" or od == "#":
        op = "."

    if od[0] == "t":
        od = "."
    if od[0] == "c":
        od = ","

    ost = sys.argv[8]              # oznaceni (oddelovac) stupnu (cislo - ASCII kod znaku)
    if ost == "" or ost == "#":    # typ parametru: integer (toolbox: integer - long)
        ost = 176                  # nepovinny, default: 176 (znak stupnu)
    else:
        ost = int(ost)

    om = sys.argv[9]               # oznaceni (oddelovac) minut (cislo - ASCII kod znaku)
    if om == "" or om == "#":      # typ parametru: integer (toolbox: integer - long)
        om = 39                    # nepovinny, default: 39 (apostrof)
    else:
        om = int(om)

    ov = sys.argv[10]              # oznaceni (oddelovac) vterin (cislo - ASCII kod znaku)
    if ov == "" or ov == "#":      # typ parametru: integer (toolbox: integer - long)
        ov = 34                    # nepovinny, default: 34 (uvozovky)
    else:
        ov = int(om)


#--------------------------------------------------------------------------------------
# Zpracovani souboru

    fin = open(vstup,"r")

    # Z prvniho nacteneho radku udelat seznam poli
    radek = fin.readline()
    radek = radek.replace("\n","")
    radek = radek.rstrip()
    polozky = radek.split(op)
    if op == " ":
        pom = []
        for q in range(len(polozky)):
            if polozky[q] <> '':
                pom.append(polozky[q])
        polozky = pom
    elif op == ",":
        for q in range(len(polozky)):
            polozky[q] = polozky[q].lstrip()
                
        
    # Testovani, zda se v radku nachazeji zadana jmena poli se souradnicemi
    # Pokud ano, zapsat se do promennych ix a iy kolikate pole je se sour. x a y
    try:
        ix = polozky.index(poleZS)
    except:
        raise "LatError"

    try:
        iy = polozky.index(poleZD)
    except:
        raise "LongError"

    # Vytvoreni pracovnich souboru
    if gp.workspace == None:
        gp.workspace = os.path.dirname(vstup)
    if gp.Describe(gp.workspace).workspacetype == "FileSystem":
        kam = gp.workspace
    else:
        kam = os.path.dirname(vstup) 
    temp = kam + r"\pracovni.txt"

    if (os.path.exists(temp)):
        x = 1
        while (os.path.exists(temp)):
            x=x+1
            temp = kam + r"\pracovni" + str(x) + ".txt"

    # Test nazvu poli
    nazvypoli = []
    for q in range(0,len(polozky)):
        polozky[q] = polozky[q].strip()  #orezani mezer v nazvech poli
        nazvypoli.append(gp.ValidateFieldName(polozky[q],os.path.dirname(vystup)))
        if nazvypoli[q] <> polozky[q]:
            gp.AddError("Nazev pole uvedeny v textovem souboru je neplatny pro cilovou tridu prvku:")
            gp.AddError("  - misto nazvu pole " + polozky[q].upper() + " bude pouzit nazev " + nazvypoli[q].upper())
    polozky = nazvypoli
    fout = open(temp,"w")
    pis = string.join(polozky,",")+"\n"
    fout.write(pis)
    
    hodnota = []
    zaznam = [] #prevedeny radek
    inv = bool(0)

    radek = fin.readline()
    radek = radek.replace("\n","")
    radek = radek.strip()
    radek_no = 1 # cislo radku

    while radek:
        if op == " ":
            pom1 = list(radek)
            pom = ""
            i = 0
            while i < len(pom1):
                pom += pom1[i]
                if pom1[i] == " ":
                    j = i + 1
                    while pom1[j] == " ":
                        j += 1
                        i += 1
                i += 1
            radek = pom

        napln = 0
        for q in range(len(radek)):
            if radek[q]<>'':
                napln = napln + 1
        if napln == 0:
            gp.AddWarning("Preskocen prazdny radek.")
        else:
            #Osetreni pripadu, ze by se oddelovac polozek nachazel i v obsahu polozek
            #Predpokladame, ze to muze nastat pouze u carky nebo mezery, v tom pripade
            #musi byt tato hodnota v uvozovkach
            if ((op == ",") or (op == " ")):
                
                polozky = []
                text = bool(0)
                n = 0
                mezera = bool(0)

                while (n < (len(radek))):
                    znak = radek[n]

                    if ((znak==op) and (text==False)):
                        if (radek[n-1] != znak):
                            polozky.append(string.join(hodnota,""))
                            hodnota = []
                        if (radek[n+1]=="\""):
                            text = True
                            n=n+1
                        
                    elif (znak=="\""):
                        if text:
                            text=False
                        elif (n==0):
                            text = True
                        else:
                            hodnota.append(znak)

                    else:
                        hodnota.append(znak)
                    n = n+1

                polozky.append(string.join(hodnota,""))
                hodnota = []

            else:
                polozky = radek.split(op)

            #Kontrola jednotlivych polozek, v pripade souradnic dojde k prevodu
            for i in range(len(polozky)):
                if (i==ix) or (i==iy):
                    if polozky[i][0] == '"' and polozky[i][-1] == '"':
                        # Je to soubor CSV, zem. souradnice jsou retezce a tedy v uvozovkach
                        polozky[i] = polozky[i][1:-1] # zruseni uvozovek na zacatku
                        polozky[i] = polozky[i].replace('""','"') # zruseni uvozovek na konci
##                    if ost <> 32 and om <> 32 and ov <> 32:
##                        polozky[i] = polozky[i].replace(' ','')
                    if od == ",":
                        polozky[i] = string.replace(polozky[i],",",".")
                    stupne = 0
                    minuty = 0
                    vteriny = 0
                    #Promenne pro pripad, ze by oddelovac stupnu, minut i vterin byl stejny
                    st = bool(1)
                    mi = bool(1)
                    vt = bool(1)
                    for j in range(len(polozky[i])):
                        znak = polozky[i][j]
                        oz = ord(znak) #prevod na kod znaku
                        inv = False
                        if znak == "W" or znak == "E" or znak == "N" or znak == "S":
                            if znak == "W" or znak == "S":
                                inv = True
                        elif ((oz == ost) and st):
                            stupne = float(string.join(hodnota,""))
                            hodnota = []
                            st = False
                        elif ((oz == om) and mi):
                            minuty = float(string.join(hodnota,""))
                            hodnota = []
                            mi = False
                        elif oz == ov or (ov == 32 and j == len(polozky[i])):
                            vteriny = float(string.join(hodnota,""))
                            hodnota = []
                            vt = False
                        else:
                            hodnota.append(znak)
                    # Osetreni pripadu, ze chybi za hodnotou oddelovac
                    if (st or mi or vt) and hodnota:
                        try:
                            cislo = float(string.join(hodnota,""))
                            if st:
                                stupne = cislo
                            elif mi:
                                minuty = cislo
                            elif vt:
                                vteriny = cislo
                        except:
                            gp.AddError("Zaznam c." + radek_no + " bud neobsahuje stupne, minuty i vteriny, nebo se je nepodarilo kompletne prevest.")
                    if (stupne or minuty or vteriny):
                        # Prepocet uhlu na desetinny tvar
                        if minuty > 60.0 or vteriny > 60.0:
                            raise "souradnice"
                        dd = stupne + minuty/60.0 + vteriny/3600.0
                        if inv:
                            dd = -dd
                            inv = False
                    else:
                        dd = float(hodnota)
                    hodnota = list(str(dd))
                    zaznam.append(string.join(hodnota,""))
                    hodnota = []
                else:
                    if polozky[i].find('"')<> -1:
                        gp.AddError("CHYBA: V polozce, ktera neni zemepisnou souradnici, se vyskytuje znak uvozovky.")
                        for ii in range(len(polozky)):
                            gp.AddError(polozky[ii])
                        raise "uvozovky"
                    else:
                        pol = '"' + polozky[i] + '"'
                        zaznam.append(pol)
                
        # Zapis prevedeneho radku do pracovniho souboru
        pis = string.join(zaznam,",")+"\n"
        fout.write(pis)
        zaznam = []
        radek = fin.readline()
        radek = radek.replace("\n","")
        radek = radek.rstrip()
        radek_no = radek_no + 1
    gp.AddMessage("Pocet zpracovanych radku se souradnicemi = " + str(radek_no-1))

    fin.close()
    fout.close()
    
    # Import do ArcGIS jako vrstva, ta se ulozi jako vystupni trida prvku
    gp.RefreshCatalog(gp.workspace)
    gp.AddMessage("Vytvareni bodove vrstvy z pracovniho textoveho souboru...")
    vrstva = gp.MakeXYEventLayer(temp, poleZD, poleZS, gp.workspace + r"\working_layer", soursys)
    gp.AddMessage("Export do bodove tridy prvku " + vystup + " ...") 
    gp.CopyFeatures(vrstva, vystup)
    
    # smazani pracovniho souboru:
    if (os.path.exists(temp)):
        os.remove(temp)
        
    gp.AddMessage("Hotovo.")
    
except "FileMissing":
    gp.AddError("Vstupni soubor nenalezen!")
    print "Vstupni soubor nenalezen!"

except "LatError":
    gp.AddError("Pole se zemepisnou sirkou nenalezeno!")
    print "Pole se zemepisnou sirkou nenalezeno!"

except "LongError":
    gp.AddError("Pole se zemepisnou delkou nenalezeno!")
    print "Pole se zempisnou delkou nenalezeno!"

except "SpRefMissing":
    gp.AddError("Pro zapis vystupu do datove sady v geodatabazi") 
    gp.AddError("je treba zadat souradnicovy system (Spatial Reference) vstupnich dat!")
    print "Pro zapis vystupu do datove sady v geodatabazi"
    print "Je treba zadat souradnicovy system (Spatial Reference) vstupnich dat!"

except "SpRefError":
    gp.AddError("Souradnicovy system vstupu se neshoduje se souradnicovym systemem cilov datove sady!")
    gp.AddWarning("TIP: nejprve ulozte vystup do samostatne tridy prvku v geodatabazi")
    gp.AddWarning("a pak jej transformujte do souradnicoveho systemu datove sady nastrojem Project.")
    gp.AddWarning("Viz ArcToolbox > Sprava dat > Souradnicove systemy a transformace > Vektorova data > Transformace...")
    gp.AddWarning("(ArcToolbox > Data Management Tools > Projections and Transformations > Feature > Project)")
    print "Zvolen souadn systm neodpovida clove datove sade!"

except "souradnice":
    gp.AddError("Chyba ve vstupni souradnici.")
    gp.AddWarning("\nProhlednete si vstupni data")
    print "\nProhlednete si vstupni data"
    if (os.path.exists(temp)):
        gp.AddWarning("a rovnez pracovni soubor:")
        gp.AddWarning(temp)
        print "a rovnez pracovni soubor:"
        print temp
        gp.AddWarning("ktery obsahuje dosud zpracovane zaznamy, ktere jsou z hlediska skriptu v poradku.")
 

except:
    gp.AddError(gp.GetMessages())
    gp.AddError("***** CHYBA ! *****")
    gp.AddWarning("Chyba vznikla pravdepodobne:")
    gp.AddWarning("- nespravnym zadanim parametru")
    gp.AddWarning("- chybou ve vstupnich datech")
    gp.AddWarning("- pokusem o zpracovani souboru, jehoz struktura neni skriptem podporovana.")
    gp.AddWarning("\nProhlednete si vstupni data")
    print gp.GetMessages()
    print "***** CHYBA ! *****"
    print "Chyba vznikla pravdepodobne:"
    print "- nespravnym zadanim parametru"
    print "- chybou ve vstupnich datech"
    print "- pokusem o zpracovani souboru, jehoz struktura neni skriptem podporovana."
    print "\nProhlednete si vstupni data"
    if (os.path.exists(temp)):
        gp.AddWarning("a rovnez pracovni soubor:")
        gp.AddWarning(temp)
        print "a rovnez pracovni soubor:"
        print temp
        gp.AddWarning("ktery obsahuje dosud zpracovane zaznamy, ktere jsou z hlediska skriptu v poradku.")
        

